/*
Reads in value from light sensor (phototransistor) and when it is dark turns on LEDs and randomly 
turns servo or turns on speaker. 

created
03/21/14
*/

#include <Servo.h> 
 
Servo myservo;                   // create servo object 
int light = 0;                   // variable to store sensor readings
int pos = 0;                     // variable to store the servo position 
int count = 0;                   // variable to store servo motions
int timer = 0;                   // variable to store random timing delays 
int dice = 0;                    // variable to store random values
const int sensor = A0;           // sensor pin 
const int speaker = 12;          // audio control pin
const int leds = 11;             // LED control pin

const int threshold = 200;       // analog value for determining light or dark
 
void setup() 
{ 
  //Serial.begin(9600);          // setup serial conection
  myservo.attach(9, 600, 2100);  // attaches the servo on pin 9 to the servo object, sets min/max pulsewidth in micros 
  myservo.write(pos);            // initializes position of servo
  pinMode(speaker, OUTPUT);      // sets speaker control pin
  digitalWrite(speaker, LOW);    // makes sure speaker is off
  pinMode(leds, OUTPUT);         // sets LED control pin
  digitalWrite(leds, LOW);       // makes sure LEDs are off
} 
 
 
void loop() 
{ 
  light = analogRead(sensor);   // read light sensor
  /*Serial.print(light);        // serial communications available for debugging
  Serial.println();*/
  
  
  if (light > threshold) {       // if there is no light
   timer = 10*random(100, 1000); // setup psuedo-random timer to range from 1-10sec
   dice = random(0,11);          // pick some random number
   
   digitalWrite(leds, HIGH);     // turn on eyes
   
   /*Serial.print(timer);
   Serial.print("\t");
   Serial.print(dice);
   Serial.println();*/
   
   if (dice%2 == 0){             // if dice is even, turn light on/off (or speaker)
     digitalWrite(speaker, HIGH); 
     delay(100);             
     digitalWrite(speaker, LOW);
     delay(2000);                         // at least 2 seconds of audio
     for (count = 0; count <9; count ++){
       if (analogRead(sensor)<threshold){ // if lights go on, stop sound
         digitalWrite(speaker, HIGH);
         delay(100);
         digitalWrite(speaker, LOW);
         break;
       }
       else {
         delay(2000);                     //run 2 more seconds of audio before checking again
       }  
     }  
   }  
   
   else {                                 // if dice is odd, turn servo back and forth
     for (count = 0; count <3; count ++){ // 3 movements of servo
       for (pos = 0; pos < 40; pos +=1){  // (might need to adjust limits of motion)
         myservo.write(pos);
         delay(15);
       }
       for (pos = 40; pos>= 0; pos -=1){
         myservo.write(pos);
         delay(15);
       }
       if (analogRead(sensor)<threshold){ // if lights go on, stop moving servo
         break;
       }
     }  
 }
  
  if (analogRead(sensor)>threshold) { // if it is still dark
      delay(timer);                   // delay for a random time
  }
  }
  
  
  else{                              // if there is light
    digitalWrite(leds, LOW);         // turn off eyes
    delay(100);
  }
  
}

