/*
  musical t-shirt
  with smoothing
  and 2 flex sensors
*/
#include "Keyboard.h"

int pushButton = 2;
int vibeBoard = 11;
int inputPin = A5;
int inputPin2 = A4;

const int numReadings = 10;

int readings[numReadings];      // the readings from the analog input
int readIndex = 0;              // the index of the current reading
int total = 0;                  // the running total
int average = 0;                // the average

const int numReadings2 = 10;

int readings2[numReadings2];      // the readings from the analog input
int readIndex2 = 0;              // the index of the current reading
int total2 = 0;                  // the running total
int average2 = 0;                // the average



void setup() {

  pinMode(pushButton, INPUT_PULLUP);

  // initialize serial communication with computer:
  Serial.begin(9600);
  // initialize all the readings to 0:
  for (int thisReading = 0; thisReading < numReadings; thisReading++) {
    readings[thisReading] = 0;
  }
   for (int thisReading2 = 0; thisReading2 < numReadings2; thisReading2++) {
    readings2[thisReading2] = 0;
  }
  Keyboard.begin();
  pinMode(vibeBoard, OUTPUT);
}

void loop() {

  int buttonState = digitalRead(pushButton);

  if (buttonState == LOW) {

    // subtract the last reading:
    total = total - readings[readIndex];
    // read from the sensor:
    readings[readIndex] = analogRead(inputPin);
    // add the reading to the total:
    total = total + readings[readIndex];
    // advance to the next position in the array:
    readIndex = readIndex + 1;

    // if we're at the end of the array...
    if (readIndex >= numReadings) {
      // ...wrap around to the beginning:
      readIndex = 0;
    }

    // calculate the average:
    average = total / numReadings;


        // subtract the last reading:
    total2 = total2 - readings2[readIndex2];
    // read from the sensor:
    readings2[readIndex2] = analogRead(inputPin2);
    // add the reading to the total:
    total2 = total2 + readings2[readIndex2];
    // advance to the next position in the array:
    readIndex2 = readIndex2 + 1;

    // if we're at the end of the array...
    if (readIndex2 >= numReadings2) {
      // ...wrap around to the beginning:
      readIndex2 = 0;
    }

    // calculate the average:
    average2 = total2 / numReadings2;
    
    // send it to the computer as ASCII digits
    Serial.print("average 1 = ");
    Serial.print(average);
    Serial.print("\t average 2 = ");
    Serial.println(average2);

    if (average2 > 500 && average2 < 510) {
   
      Keyboard.press('b');
      delay(50);
      Keyboard.releaseAll();
 
    } else if (average > 500 && average < 510) {
        Keyboard.press('n');
      delay(50);
      Keyboard.releaseAll();
    }
  }
}


