// AP Digital Light
// Multy mode spirograph
// with serial output for test messaging 
//
// 09.12.2010
// 12.25.2010 - added EEPROM activity LED indicator
// 12.28.2010 - min delay for slide show set to 3 Sec 
//
// Hardware addon:
// mode switches
// - RANDOM/MEM 0/1
// - CONT/STEP
// - PROG/CYCLE
// STEP/PROG button


#include "C:\projects\pic\PIC18LF1220\PIC\a.h"

//define use of serial output for test messages (PIN_B1 - TX, PIN_B4 - RX) 
//#define SERIAL_MONITORING


// 3 channel software PWM driver
// blanking signal with variable frequency
// 
// timer0 - PWM period 
// timer1 - short time intervals
//	interval  IDutyInc - between duty increment in auto mode(fading)  	- 0.13 S
// timer3 - long time intervals
//  interval  IState - between state switching in auto mode  			- 60 S

//void rand_duty(int &r, int &rN);
void rand_dutyA(int &r, int &rN);
void rand_dutyB(int &r, int &rN);
void rand_dutyC(int &r, int &rN);

// using pins

// analog inputs 
// A0 - analog input 1
// A1 - analog input 2
// A2 - analog input 3
//
// controlled outputs
// B3
// B2
// A7
//
// !!!! test output !!!!
// B0
//
// blanking signal
// B1
//
// mode switches
// A4 - Prog/Cycle
// B0 - Cont/Step
// B5 - Rand/Mem
// step button
// A3 - Step/Mem

// A6 - LED MEM activity


//#define test_pin PIN_A3 
#define test_pin PIN_B1 

#define channel_A_pin PIN_B3
#define channel_B_pin PIN_B2 
#define channel_C_pin PIN_A7 

#define analog_A 0
#define analog_B 1
#define analog_C 2 

#define m_RAND_MEM_pin PIN_B5
#define m_CONT_STEP_pin PIN_B0
#define m_PROG_CYCLE_pin PIN_A4
#define step_button_pin PIN_A3

#define LED_MEM PIN_A6 

//#define blanking_pin PIN_B1
//int blanking = 0;
//int blanking_set = 255;

// global variable 
// logic flag for test purpose
boolean k = 0;

// logic flag - time interval IDutyInc has passed (0.1S)
//(duty value increasing in auto mode)
boolean fDutyInc = 0;

//logic flag - button event
//button STEP/MEM
boolean fButtonSM = 0; 

//data stored in EEPROM (256 bytes)
// 
// addr 0 - current duty A 
// addr 1 - - duty B
// addr 2 - - duty C
// addr 3 - table size (number of records, each record - 3 bytes, ABC)
// addr 16 - duty table (max - 80 records ABC)

//address of current duty value in EEPROM
BYTE address_duty=0;
//addres of table size
BYTE address_table_ind=3;
int table_ind = 0;	//initially table index = 0, maximum = 79 
//addres of table 
BYTE address_table=16;

#define MAX_TABLE_IND 79


//pointer to ABC data in table
int current_table_ind = 0;

//duty values
int A_duty=80;
int B_duty=182;
int C_duty=61;
int A_dutyNew=32;
int B_dutyNew=64;
int C_dutyNew=128;

//current value of timer 0 (PWM period)
int pwm_tik = 0;
//current time value from timer(long interval)
int duty_time = 0;			//time interval for duty increasing
int current_time = 0;		//time interval for EEPROM write (10Sec) 
int long_time = 0;			//fast duty switching
int16 state_time = 0;		//time constant for state mashine
//for CONT mode time interval for one frame vary 3 to 60 sec 
int16 frame_time = 0;		//current frame time (one tik - 0.1Sec) 
int16 frame_interval = 0;  	//interval depends on pot A

//period is equal LONG_PERIOD * timer3 period 
#define LONG_PERIOD 100		//10 Sec	time period between duty switching(fast switch)
#define STATE_PERIOD 600	//60 Sec time period between state switching(fading-switching)	

//timer0 preset 
#define timer0_preset 127

//timer1 preset 
#define timer1_preset 40535

//timer preset value to control period of timer
//int16 timer_preset = 0;

//states in auto mode 
// 0 - fading 
// 1 - fast switching
// 2 - slow switching
int state = 0;

//button state
//input is pulled up by resistor 
//default level - HIGH 
// 0 - pressed
// 1 - released
// 2 - returning to default state
int button_state = 0;


// mode switch PROG/CYCLE
// 0 - manual set of duty's value through ADC reading 
// 1 - auto (random or read from table)
boolean mode_PROG_CYCLE;

// mode switch CONT/STEP
//in continious mode duration for single frame depends on pot A   
// 0 - continious
// 1 - step
boolean mode_CONT_STEP;

// mode switch RAND/MEM
// 0 - calculation of random value
// 1 - read value from the table
boolean mode_RAND_MEM; 


// PWM period
#int_RTCC  high 
void RTCC_isr()
{

set_timer0(timer0_preset);

//output_toggle(test_pin);


	pwm_tik++;

	
	if(pwm_tik == 0)
	{
		output_high(channel_A_pin);
		output_high(channel_B_pin);
		output_high(channel_C_pin);

	}
	else
	{
		{

			if(pwm_tik >= A_duty)
			{
				output_low (channel_A_pin);
			}
			if(pwm_tik >= B_duty)
			{
				output_low (channel_B_pin);
			}
			if(pwm_tik >= C_duty)
			{
				output_low (channel_C_pin);
			}
		}
	}
}

// timer1 - short time intervals between modifying of duty value
//

#int_TIMER1 //noclear
void TIMER1_isr() 
{
	set_timer1(timer1_preset);	//period 0.1S
	
	mode_PROG_CYCLE = input(m_PROG_CYCLE_pin);
	mode_RAND_MEM = input(m_RAND_MEM_pin);
	mode_CONT_STEP = input(m_CONT_STEP_pin);

	//button state	
	//pin is pulled up to high level 
	switch(button_state)
	{
		case 0:
			if(!input(step_button_pin))
			{
			 	button_state = 1;	//low level - button pressed
			}
		break;
		case 1:
			if(input(step_button_pin))
			{
			 	button_state = 2;	//high level - button released 
				fButtonSM = 1;		//set button event
			}
		break;
		case 2:
			button_state = 0;	//return to initial state
		break;	
	}
	
	//turn OFF MEM activity LED 
	output_low(LED_MEM);

	//read current mode  
	//mode = input(mode_switch_pin); 
	fDutyInc = 1;	//duty increment must be done
}

//#int_TIMER3
//void TIMER3_isr()
//{
//}

//#int_EEPROM
//void EEPROM_isr()
//{
//}


void main()
{

  	byte valueA;
  	byte valueB;
  	byte valueC;

	int s123 = 0;
	int b123 = 0;
	int temp = 0;

    setup_oscillator(OSC_8MHZ); 
   	setup_adc(ADC_CLOCK_INTERNAL|ADC_TAD_MUL_0);
	setup_adc_ports(sAN0|sAN1|sAN2|VSS_VDD);

   	setup_wdt(WDT_OFF);
	setup_ccp1(CCP_OFF);
	
	//timer0 - PMW period
	//timer0 is configured as an 8-bit timer/counter
	//period = Tosc * 4 * Prescaler * 256 = 0.125 uS * 4 * 64 * 256 = 8.192mS
	//PWM frequency - 122Hz
	setup_timer_0(RTCC_INTERNAL|RTCC_DIV_1|RTCC_8_BIT); 
	set_timer0(timer0_preset);		//period 48	uS, 48uS * 256 = 12.288 mS
 
	//timer1 short time intervals
	//period = Tosc * 4 * Prescaler * 65536 = 0.125 uS * 4 * 4 * 65536 = 0.1310172S
	setup_timer_1( T1_INTERNAL | T1_DIV_BY_8 );
	set_timer1(timer1_preset);	//40535 period =0.1S

	//timer1 long time intervals
	//period = Tosc * 4 * Prescaler * 65536 = 0.125 uS * 4 * 8 * 65536 = 0.262144S
	setup_timer_3(T3_DISABLED);
	//setup_timer_3( T1_INTERNAL | T1_DIV_BY_8 );

   	setup_timer_2(T2_DISABLED,0,1);
	enable_interrupts(INT_TIMER1);
//	enable_interrupts(INT_TIMER3);
	enable_interrupts(INT_TIMER0);
//	enable_interrupts(INT_EEPROM);

	enable_interrupts(GLOBAL);

	output_high(LED_MEM);	//MEM LED

	valueA = read_EEPROM(address_duty); 
	if(valueA >0 && valueA <255)	A_duty = valueA; 
		else	rand_dutyA(A_duty,A_dutyNew);
	
	valueB = read_EEPROM(address_duty+1); 
	if(valueB >0 && valueB <255)	B_duty = valueB;	
		else	rand_dutyB(B_duty,B_dutyNew);
	
 	valueC = read_EEPROM(address_duty+2); 
	if(valueC >0 && valueC <255)	C_duty = valueC;
		else	rand_dutyC(C_duty,C_dutyNew);

//	output_low(LED_MEM);

	if(!input(step_button_pin))
	//button pressed - reset table_ind 
	{
		table_ind = 0;
		//save new table_ind
		write_EEPROM(address_table_ind,table_ind);
	}
	else
	{
		table_ind = read_EEPROM(address_table_ind);
		if(table_ind > MAX_TABLE_IND) //mazimum value = 79
		{
			table_ind = 0;
			//save new table_ind
			write_EEPROM(address_table_ind,table_ind);
		}
	}

	//======================================
	#ifdef  SERIAL_MONITORING
	printf("AP Digital light 2010. Laser spirograph V2.1 \n\r");
	printf("Initial data: index - %u A - %u B - %u C - %u\n\r",table_ind, A_duty, B_duty, C_duty);
	#endif

	for(;;)
	{
		//short time period - 0.1S (duty increment, ADC reading) 
		if(fDutyInc)
		{
			fDutyInc = 0;

			long_time++;	//long time interval(duty switching)
			state_time++;	//time interval for state machine
			current_time++;	//time interval for EEPROM data writing 

			//state period - 60S
			if(state_time >= STATE_PERIOD)
			{
				state_time = 0;

				switch(state) {
					case 0:
						state = 1; //switching
					break;
					case 1:
						state = 0; //fading
					break;
				}
			}


			if(mode_PROG_CYCLE) 
			//=============================================//
			// 1 - cycle mode (random or table reading)     // 
			//=============================================//
			{
				if(mode_RAND_MEM)
				//------------------------------------------------//
				// 1 - memory mode (read duty values from memory  //
				//------------------------------------------------//
				{
					if(mode_CONT_STEP)
					//----------------------------------------------//
					//  1 - step mode 								//
					//----------------------------------------------//
					{
						//STEP button event 
						if(fButtonSM)
						{
							output_high(LED_MEM);	//MEM LED

							if(table_ind>0)
							//if table is empty - exit
							{ 
								//get address of current data ABC
								temp = address_table + current_table_ind * 3;
								A_duty = read_EEPROM(temp);
								B_duty = read_EEPROM(temp+1);
								C_duty = read_EEPROM(temp+2);
								current_table_ind +=1;
								if(current_table_ind >= table_ind)
								{
									current_table_ind = 0;
								}
							}		

//							output_low(LED_MEM);

							//reset flag
							fButtonSM = 0;
						}
					}
					else //if(mode_CONT_STEP)
					//----------------------------------------------//
					//  0 - continuous mode 	    				//
					//----------------------------------------------//
					{
						//read A input and modify frame time interval
						set_adc_channel( analog_A );
						delay_us(10);
						temp = read_adc();
						
						//set minimal interwals to 3 sec
						if (temp<13) temp = 13;
												
						frame_interval = temp * 2.35; //255 = 600 timer tik (60 sec)  
	
						frame_time++;
						if(frame_time >= frame_interval)
						{
							frame_time = 0;
							if(table_ind>0)
							//if table is empty - exit
							{ 
	
								output_high(LED_MEM);	//MEM LED
	
								//get address of current data ABC
								temp = address_table + current_table_ind * 3;
								A_duty = read_EEPROM(temp);
								B_duty = read_EEPROM(temp+1);
								C_duty = read_EEPROM(temp+2);
								current_table_ind +=1;

								if(current_table_ind >= table_ind)
								{
									current_table_ind = 0;
								}
							}		
						}
					}
				}
				else //if(mode_RAND_MEM)
				//----------------------------------------------//
				// 0 - random mode								//
				//----------------------------------------------//
				{
					//0.5S time interval for duty increment
					duty_time++;
					if (duty_time >= 5)
					{
						duty_time = 0;

					//state machine (fading - switching)
					switch(state) {
	
						//fading
						case 0:

							if(A_duty != A_dutyNew) {
								if(A_duty<A_dutyNew) A_duty++;
								else A_duty--;
							}
							else
							{
								rand_dutyA(A_duty,A_dutyNew);
							}

							if(B_duty != B_dutyNew) {
								if(B_duty<B_dutyNew) B_duty++;
								else B_duty--;
							}
							else
							{
								rand_dutyB(B_duty,B_dutyNew);
							}

							if(C_duty != C_dutyNew) {
								if(C_duty<C_dutyNew) C_duty++;
								else C_duty--;
							}
							else
							{
								rand_dutyC(C_duty,C_dutyNew);
							}
						break;

						//fast switching
						case 1:

							//svitching period - 10S
							if(long_time >= LONG_PERIOD)
							{
								long_time = 0;
								rand_dutyA(A_duty,A_dutyNew);
								A_duty = A_dutyNew;

								rand_dutyB(B_duty,B_dutyNew);
								B_duty = B_dutyNew;

								rand_dutyC(C_duty,C_dutyNew);
								C_duty = C_dutyNew;
							}//end if(long_time == LONG_PERIOD)
						break;
			
						case 2:
						break;
					}	//end of switch(state)
	


					//======================================
//					#ifdef  SERIAL_MONITORING
//					printf("Random t:%03Lu A - %03u B - %03u C - %03u              \r", state_time, A_duty, B_duty, C_duty);
//					#endif

					}// end if (duty_time == 10)

				} // if(mode_RAND_MEM)

			}//if(mode)


			//================================//
			// 0 - programming (manual) mode  // 
			//================================//
			else
			{
				//read ADC inputs and modify duty values

				set_adc_channel( analog_A );
				delay_us(10);
				A_duty = read_adc();
				
				//duty value cannot be equal 0 because random generator will return 0
				if(!A_duty)
				{
					A_duty = 1;	
				}

				set_adc_channel( analog_B );
				delay_us(10);
				B_duty = read_adc();
				if(!B_duty)
				{
					B_duty = 1;	
				}

				set_adc_channel( analog_C );
				delay_us(10);
				C_duty = read_adc();
				if(!C_duty)
				{
					C_duty = 1;	
				}


				//======================================
//				#ifdef  SERIAL_MONITORING
//				printf("Manual A - %03u B - %03u C - %03u                   \r",A_duty, B_duty, C_duty);
//				#endif

	

			}//else(mode)

			//MEM button event 
			if(fButtonSM)
			{
				//reset button flag
				fButtonSM = 0;

				//ignore button event in MEMORY/CYCLE mode
				if(!mode_RAND_MEM)
				{
					//output_high(test_pin);
					output_high(LED_MEM);	//MEM LED

					temp = address_table + table_ind * 3; 
					//save current duty value in table   				
					write_EEPROM(temp,A_duty);	
					write_EEPROM(temp+1,B_duty);	
					write_EEPROM(temp+2,C_duty);	
					table_ind += 1;		
					if(table_ind > MAX_TABLE_IND)
					{
						table_ind = 0;		
					}	
					//save new table_ind
					write_EEPROM(address_table_ind,table_ind);
					
					//output_low(test_pin);

				}
			}

			//write current data into EEPROM memory
			//writing procedure CANNOT be interrupted!!!
			//delay is several mS (5mS)
			if(current_time >= 100)	//10sec time interval
			{
//				output_toggle(test_pin);
				output_high(LED_MEM);	//MEM LED

				current_time = 0;
				switch(s123)
				{
					case 0:
						s123 = 1;
						write_EEPROM(address_duty,A_duty);			
					break;
					case 1:
						s123 = 2;
						write_EEPROM(address_duty+1,B_duty);			
					break;
					case 2:
						s123 = 0;
						write_EEPROM(address_duty+2,C_duty);	
					break;
				}

			}//if(current_time

	//=================================
	#ifdef  SERIAL_MONITORING
		if(mode_PROG_CYCLE) 
		{
			printf("Ccl ");
		}
		else
		{
			printf("Prg ");
		}
		if(mode_RAND_MEM)
		{
			printf("Mem ");
		}
		else
		{
			printf("Rnd ");
		}
		if(mode_CONT_STEP)
		{
			printf("Stp ");
		}
		else
		{
			printf("Cnt ");
		}
		printf("ind - %02u cind - %02u f:%03Lu cf:%03Lu t:%03Lu A %03u B %03u C %03u  \r", 
table_ind, current_table_ind, frame_interval, frame_time, state_time, A_duty, B_duty, C_duty);
	#endif


		}//if(fDutyInc)

	}//for
 
}


void rand_dutyA(int &r, int &rN){
	//value cannot be equal 0 !!!
	if(!r) r = 1;
	rN = r;
	//only one motor at the time can be stopped 	
	if(B_duty > 64 && C_duty > 64)
	{
		shift_right(&rN,1,(bit_test(rN,2)^bit_test(rN,0)));	
	}
	//omit duty values less than 64 (motor will not spin)
	else
	{
		do
		{
			shift_right(&rN,1,(bit_test(rN,2)^bit_test(rN,0)));
		}	while (rN<=64);
	}
}
void rand_dutyB(int &r, int &rN){
	//value cannot be equal 0 !!!
	if(!r) r = 1;
	rN = r;
	//only one motor at the time can be stopped 	
	if(A_duty > 64 && C_duty > 64)
	{
		shift_right(&rN,1,(bit_test(rN,2)^bit_test(rN,0)));	
	}
	//omit duty values less than 64 (motor will not spin)
	else
	{
		do
		{
			shift_right(&rN,1,(bit_test(rN,2)^bit_test(rN,0)));
		}	while (rN<=64);
	}
}
void rand_dutyC(int &r, int &rN){
	//value cannot be equal 0 !!!
	if(!r) r = 1;
	rN = r;
	//only one motor at the time can be stopped 	
	if(B_duty > 64 && A_duty > 64)
	{
		shift_right(&rN,1,(bit_test(rN,2)^bit_test(rN,0)));	
	}
	//omit duty values less than 64 (motor will not spin)
	else
	{
		do
		{
			shift_right(&rN,1,(bit_test(rN,2)^bit_test(rN,0)));
		}	while (rN<=64);
	}
}

