// Target : mega8

/*
20060115 dan goldwater
squid labs llc

persistence of vision toy

code built for Imagecraft C compiler, minimal changes needed to use gcc tools.
*/

#include <iom8v.h>
#include <macros.h>

#define setbit(x,y)   (x |= (1 << (y)))
#define clearbit(x,y) (x &= ~(1 << (y)))
#define checkbit(x,y) (x & (1 << (y)))

#define NUMLEDS 10
// ohms for lowest resistor, other resistors are 10x, 100x and 1000x this value

//unsigned short timer1 = 0;

#define temp1 (*(volatile unsigned short *)0x4A)

#define RED_LED_ON setbit(PORTB, 7)
#define RED_LED_OFF clearbit(PORTB, 7)
#define GREEN_LED_ON setbit(PORTB, 6)
#define GREEN_LED_OFF clearbit(PORTB, 6)

// turn yellow leds on/off
void led(char id, char state) {
  if(id < 2) {
    if(state) setbit(PORTD, id);
    else      clearbit(PORTD, id);
  }
  else if(id < 7) {
    if(state) setbit(PORTD, id+1);
    else      clearbit(PORTD, id+1);
  }
  else if(id < 10) {
    if(state) setbit(PORTB, id-7);
    else      clearbit(PORTB, id-7);
  }
}

// display lower 10 bits of a short on yellow leds
void ledbin(unsigned short x) {
  unsigned char i;
  for(i=0; i<10; i++) {
    led(i, x & 0x01);
    x >>= 1;
  }
}

#pragma interrupt_handler int0_isr:2
void int0_isr(void)
{
  RED_LED_ON;
}


//call this routine to initialise all peripherals
void init_devices(void)
{
  //stop errant interrupts until set up
  CLI(); //disable all interrupts

  // port init
  PORTB = 0x38;
  DDRB  = 0xC7;
  PORTC = 0x7F;
  DDRC  = 0x00;
  PORTD = 0x04;
  DDRD  = 0xFB;
  //DDRD = 0x00;

  // mcu setup
  MCUCR = 0x00;
  GICR = 0x40;  // enable int0
  TIMSK = 0x00; //timer interrupt sources
  SEI(); //re-enable interrupts
  //all peripherals are now initialised
}

// cycle the leds for fun
void blinkme(void) {
  unsigned char i, j;
  unsigned short x;
  for(j=0; j<NUMLEDS+1; j++) {
    for(i=0; i<NUMLEDS; i++) {
	  led(i, i==j);
	}
	for(x=0; x<10000; x++) {}
  	//x = timer1;
  	//while((timer1 - x) < 10) {}
  }
}

void blinkme2(void) {
  unsigned char i;
  for(i=0; i<2; i++) {
    RED_LED_ON;
    GREEN_LED_OFF;
    blinkme();
    RED_LED_OFF;
    GREEN_LED_ON;
    blinkme();
  }
}

void sleep(unsigned short t) {
  unsigned char i = 0;
  unsigned short j;
  for(j=0; j<t; j++) {
    i++;
  }
}

// tweak here the timings on the persistence of vision
#define WAIT1 750
#define WAIT2 1500
C_task void main(void)
{
  unsigned short t, u;
  unsigned char i, j;
  
  init_devices();

  blinkme2();

  DDRC = 0x00;
  PORTC = 0x60;

  for(;;) {
    RED_LED_OFF;
    GREEN_LED_OFF;
    
    // here we hard-coded a few letters using a 9x5 pixel font.
    
// s
    ledbin(0000);
    sleep(WAIT2);
    sleep(WAIT2);
    sleep(WAIT2);
    sleep(WAIT2);

    ledbin(0763);
    sleep(WAIT1);
    ledbin(0663);
    sleep(WAIT1);
    ledbin(0421);
    sleep(WAIT1);
    ledbin(0633);
    sleep(WAIT1);
    ledbin(0637);
    sleep(WAIT1);
// q
    ledbin(0000);
    sleep(WAIT2);

    ledbin(0174);
    sleep(WAIT1);
    ledbin(0202);
    sleep(WAIT1);
    ledbin(0405);
    sleep(WAIT1);
    ledbin(0203);
    sleep(WAIT1);
    ledbin(0175);
    sleep(WAIT1);
// u
    ledbin(0000);
    sleep(WAIT2);

    ledbin(0777);
    sleep(WAIT1);
    ledbin(0001);
    sleep(WAIT1);
    ledbin(0001);
    sleep(WAIT1);
    ledbin(0001);
    sleep(WAIT1);
    ledbin(0777);
    sleep(WAIT1);
// i
    ledbin(0000);
    sleep(WAIT2);

    ledbin(0401);
    sleep(WAIT1);
    ledbin(0401);
    sleep(WAIT1);
    ledbin(0777);
    sleep(WAIT1);
    ledbin(0401);
    sleep(WAIT1);
    ledbin(0401);
    sleep(WAIT1);
// d
    ledbin(0000);
    sleep(WAIT2);

    ledbin(0777);
    sleep(WAIT1);
    ledbin(0401);
    sleep(WAIT1);
    ledbin(0401);
    sleep(WAIT1);
    ledbin(0202);
    sleep(WAIT1);
    ledbin(0174);
    sleep(WAIT1);
  }
}
