<?php
  
  // this script is a webapp for mobile browsers.
  // it gets data from the sqlite database and shows the user things like the current temperature at home.
  // if the users sets a new goal temperature, it is passed on to setThermostat.php.


   class MyDB extends SQLite3
   {
      function __construct()
      {
         $this->open('thermostaat.db');
      }
   }
   $db = new MyDB();
   if(!$db){
      echo $db->lastErrorMsg();
      exit;
   } else {
      // echo "Opened database successfully\n";
   }

   $sql ="SELECT * from temperatuur ORDER BY ID DESC LIMIT 1";

   $ret = $db->query($sql);
   while($row = $ret->fetchArray(SQLITE3_ASSOC) ){
      $temperature = $row['temperatuur'];
      $humidity = $row['luchtvochtigheid'];
      $heater = $row['heater'];
      $timestamp = $row['timestamp'];
      $goaltemp = $row['goaltemp'];
   }

    // get temperature data from last 24 hours
    // source: https://nyquist212.wordpress.com/2014/03/28/example-to-connect-to-sqlite-with-php-and-return-json/
    // Iterate through the results and pass into JSON encoder
   $sql ="SELECT timestamp, temperatuur from temperatuur ORDER BY ID DESC LIMIT 1440";
   $ret = $db->query($sql);
   while($row = $ret->fetchArray(SQLITE3_ASSOC) ){
      $temperatuurdata24uur[]= $row;
    }
    $temperatuurdata24uur = json_encode($temperatuurdata24uur);

   $db->close();
?>


<!DOCTYPE html>
<html>
<head>
  <title>Thermostaat</title>
  <meta charset="utf-8">
  <!-- Include meta tag to ensure proper rendering and touch zooming -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Include jQuery Mobile stylesheets -->
  <link rel="stylesheet" href="http://code.jquery.com/mobile/1.4.5/jquery.mobile-1.4.5.min.css">
  <!-- Include the jQuery library -->
  <script src="http://code.jquery.com/jquery-1.11.3.min.js"></script>
  <!-- Include the jQuery Mobile library -->
  <script src="http://code.jquery.com/mobile/1.4.5/jquery.mobile-1.4.5.min.js"></script>

  <!-- sources for the graph -->
  <link href='http://fonts.googleapis.com/css?family=PT+Sans' rel='stylesheet' type='text/css'>
  <link href='graph.css' rel='stylesheet' type='text/css'>
  <script src="http://d3js.org/d3.v3.js"></script>

    <style type="text/css">
    dt, dd {
      display: block;
      float: left;
   }
    dt { 
      clear: both;
      width: 100px;
   }
   </style>
</head>
<body>

<div data-role="page" id="pageone" data-theme="a">
  <div data-role="header">
    Thermostaat
  </div>

  <div data-role="main" class="ui-content">

    <div style="clear: both;">

    <!-- 
    // showing a D3 responsive graph of the temperature in the last 24 hours 
    // source: https://www.safaribooksonline.com/blog/2014/02/17/building-responsible-visualizations-d3-js/
    -->
    <svg id="graph" viewBox="0 0 960 500" preserveAspectRatio="xMidYMid"></svg>

    <script>

    var margin = 40,
        width = 960 - margin*2,
        height = 500 - margin*2;

    var xScale = d3.time.scale()
        .range([0, width])
        .nice(d3.time.day);

    var yScale = d3.scale.linear()
        .range([height, 0])
        .nice();

    var xAxis = d3.svg.axis()
        .scale(xScale)
        .orient("bottom");

    var yAxis = d3.svg.axis()
        .scale(yScale)
        .orient("left");

    var line = d3.svg.line()
        .x(function(d) { return xScale(d.date); })
        .y(function(d) { return yScale(d.temperatuur); });

    var graph = d3.select("#graph")
        .attr("width", width + margin*2)
        .attr("height", height + margin*2)
        .append("g")
        .attr("transform", "translate(" + margin + "," + margin + ")");

      var data = '<?php print $temperatuurdata24uur; ?>';

      data = JSON.parse( data );

      data.forEach(function(d) {
        d.date = d3.time.format("%Y-%m-%d %H:%M:%S").parse(d.timestamp); // 2016-01-17 19:46:01
        d.temperatuur = +d.temperatuur;
      });



      xScale.domain(d3.extent(data, function(d) { return d.date; }));
      yScale.domain(d3.extent(data, function(d) { return d.temperatuur; }));

      graph.append("g")
          .attr("class", "x axis")
          .attr("transform", "translate(0," + height + ")")
          .call(xAxis);

      graph.append("g")
          .attr("class", "y axis")
          .call(yAxis)
        .append("text")
          .attr("transform", "rotate(-90)")
          .attr("y", 6)
          .attr("dy", ".71em")
          .style("text-anchor", "end")
          .text("Temperature (C)");

      graph.append("path")
          .datum(data)
          .attr("class", "line")
          .attr("d", line);

    </script>

   </div>

   <dl>
      <dt>Temperature:</dt><dd><?php print $temperature; ?>&deg;</dd>
      <dt>Humidity:</dt><dd><?php print $humidity; ?>&#37;</dd>
      <dt>Heater:</dt><dd><?php $heater ? print "off" : print "on"; ?></dd>
      <dt>Goal:</dt><dd id="goallistitem"><?php print $goaltemp; ?>&deg;</dd>
   </dl>

   <div style="clear: both;">&nbsp;</div>

    <form method="get" action="setThermostat.php" id="thermoSettings" data-ajax=”false”>
      <div><fieldset data-role="controlgroup">
          <label for="switch_day">Aan (set temp below)</label>
          <input type="radio" name="switch" id="switch_day" value="day">
          <label for="switch_night">Nacht (16&deg;)</label>
          <input type="radio" name="switch" id="switch_night" value="night">
          <label for="switch_freeze">Antivries (5&deg;)</label>
          <input type="radio" name="switch" id="switch_freeze" value="antifreeze">
      </fieldset></div>

      <div class="ui-field-contain">
        <label for="temperature"><strong>Goal temperature</strong></label>
        <input name="temperature" id="temperature" min="17" max="23" step=".1" value="20.5" type="range" data-popup-enabled="true">
      </div>

      <script>
          // make the form reflect the current goal temperature in the thermostat when the script starts
          $( "#pageone" ).on( "pagecreate", function( event, ui ) {
            var goaltemp = <?php print $goaltemp; ?>;
            if ( goaltemp > 16.00 ) {
              $("input[type='radio']:eq(0)").attr("checked",true);
              $('#temperature').slider('enable'); // and enable the slider
              $("#temperature").val(parseFloat(String(goaltemp).replace(',','.'))).slider("refresh");
            } else if ( goaltemp == 16.00 ) {
              $("input[type='radio']:eq(1)").attr("checked",true);
              $('#temperature').slider('disable');
            } else if ( goaltemp == 5.00 ) {
              $("input[type='radio']:eq(2)").attr("checked",true);
              $('#temperature').slider('disable');
            }
            $("input[type='radio']").checkboxradio("refresh");
          });

          // when the slider has been moved, send the new settings to the thermostat.
          $(function() {
               $("#temperature").on( "slidestop", function( event, ui ) { 
                sendNewTemperature($('#temperature').val()); // Send data to server through an Ajax call.
              });
          });

          // if a radio button is pressed, send a new goal temperature to the thermostat
          // and enable/disable the slider.
         $("input[type='radio']").bind( "change", function(event, ui) {

            if ( $("#thermoSettings :radio:checked").val() == 'day') {
              $('#temperature').slider('enable'); 
            } else {
              $('#temperature').slider('disable'); 
            }

             // set the new goal temperature
            if ( $("#thermoSettings :radio:checked").val() == 'day' ) {
              sendNewTemperature($('#temperature').val()); // set temperature to the slider value
            } else if ( $("#thermoSettings :radio:checked").val() == 'night' ) {
              sendNewTemperature('16.00');
            } else if ( $("#thermoSettings :radio:checked").val() == 'antifreeze' ) {
              sendNewTemperature('5.00');
            }

         });


         function sendNewTemperature($newgoal) {
          // Send data to server through an Ajax call.
          // from an example here: http://www.gajotres.net/complex-jquery-mobile-authorization-example/

           $.ajax({url: 'setThermostat.php',
           // data: {formData : $('form#thermoSettings').serialize()},
           data: { 'goal': $newgoal },
           type: 'post',                  
           async: 'true',
           dataType: 'json',
           beforeSend: function() {
               // This callback function will trigger before data is sent
               $.mobile.loading('show'); // This will show Ajax spinner
           },
           complete: function() {
               // This callback function will trigger on data sent/received complete   
               $.mobile.loading('hide'); // This will hide Ajax spinner
           },
           success: function (result) {
               // Check if authorization process was successful
               if ( result > 0 ) {
                  // change goal temperature on the page to the newly set temperature
                  $('dd#goallistitem').html(result);
               } else {
                   alert('Setting new goal temperature failed');
               }
           },
           error: function (request,error) {
               // This callback function will trigger on unsuccessful action               
               alert('Network error has occurred please try again!');
           }
          });

         }

      </script>

    </form>

  </div>

  <div data-role="footer">
  </div>
</div> 

</body>
</html>




