unit mainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Spin, Grids, ExtCtrls;

const
     delai_base = 10;       //* Dlai d'attente de base (en ms)
type
    TFrame = Array[0..4] of integer;
    TMemory = Array[0..3] of integer;

type
  TmainForm = class(TForm)
    grille: TStringGrid;
    GroupBox1: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    ckb_Boucle: TCheckBox;
    ctl_speed: TSpinEdit;
    btn_prev: TBitBtn;
    aff_step: TLabel;
    btn_next: TBitBtn;
    btn_play: TBitBtn;
    btn_stop: TButton;
    TimerLecture: TTimer;
    btn_open: TBitBtn;
    btn_save: TBitBtn;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    btn_first: TButton;
    btn_last: TButton;
    btn_delete: TBitBtn;
    btn_insert: TBitBtn;
    ckb_random: TCheckBox;
    btn_new: TBitBtn;
    procedure grilleSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure FormShow(Sender: TObject);
    procedure grilleDrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure btn_nextClick(Sender: TObject);
    procedure btn_prevClick(Sender: TObject);
    procedure TimerLectureTimer(Sender: TObject);
    procedure btn_playClick(Sender: TObject);
    procedure btn_stopClick(Sender: TObject);
    procedure btn_openClick(Sender: TObject);
    procedure btn_saveClick(Sender: TObject);
    procedure btn_firstClick(Sender: TObject);
    procedure btn_lastClick(Sender: TObject);
    procedure btn_deleteClick(Sender: TObject);
    procedure btn_insertClick(Sender: TObject);
    procedure ckb_randomClick(Sender: TObject);
    procedure btn_newClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure dessine_grille;
    procedure update_interface;
    procedure load_sequence_file;
    procedure save_sequence_file;
    function convertir(m: TFrame): TMemory;

  end;

var
  mainForm: TmainForm;
  sequence: Array of TFrame;
  sequence_File, hex_file: TextFile;
  step: integer;

implementation

{$R *.DFM}

function IsBitSet(const val: longint; const TheBit: byte): boolean;
begin
result:= (val and (1 shl TheBit)) <>0;
end;

function BitToggle(const val: byte; const TheBit: byte): byte;
begin
result:= val xor (1 shl TheBit);
end;

procedure TMainForm.dessine_grille;
var
   col, row: integer;
begin
for col:= 0 to 4 do
    for row:= 0 to 4 do
        begin
        if IsBitSet(sequence[step,col], row)
           then grille.Canvas.Brush.Color:= clRed
           else grille.Canvas.Brush.Color:= clBlack;
        grille.canvas.fillrect(grille.cellrect(col,row));
        end;
end;


procedure TmainForm.grilleSelectCell(Sender: TObject; ACol, ARow: Integer;
  var CanSelect: Boolean);
begin
sequence[step,ACol]:= BitToggle(sequence[step,ACol], ARow);
dessine_grille;
end;

procedure TmainForm.FormShow(Sender: TObject);
var
   i: integer;
begin
randomize;
opendialog1.InitialDir:= extractfilepath(application.exename);
savedialog1.InitialDir:= extractfilepath(application.exename);
setlength(sequence,1);
for i:= 0 to 4 do
    begin
    sequence[0,i]:= 0;
    end;
step:= 0;
update_interface;
end;

procedure TmainForm.grilleDrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
begin
dessine_grille;
end;

procedure TmainForm.btn_nextClick(Sender: TObject);
var
   i: integer;
begin
step:= step+1;
if step=length(sequence) then
   begin
   setlength(sequence,step+1);
   for i:=0 to 4 do
       sequence[step,i]:=0;
   end;
update_interface;

end;

procedure TMainForm.update_Interface;
begin
dessine_grille;
aff_step.Caption:= intToStr(step+1)+'/'+intToStr(length(sequence));

if timerLecture.Enabled
   then
       begin
       btn_prev.enabled:= false;btn_next.enabled:= false;
       btn_play.Enabled:= false; btn_stop.Enabled:= true;
       btn_save.enabled:=false;btn_open.Enabled:= false;
       btn_first.enabled:=false;btn_last.enabled:=false;
       btn_delete.enabled:=false;btn_insert.enabled:=false;
       grille.enabled:=false;
       end
   else
       begin
       if step<=0
          then btn_prev.enabled:= false
          else btn_prev.enabled:= true;
       btn_next.enabled:= true;
       btn_play.Enabled:= true; btn_stop.Enabled:= false;
       btn_save.enabled:= true; btn_open.Enabled:= true;
       btn_first.enabled:=true;btn_last.enabled:=true;
       btn_delete.enabled:=true;btn_insert.enabled:=true;
       if length(sequence)>1
          then btn_delete.Enabled:=true
          else btn_delete.Enabled:= false;
       grille.enabled:=true;
       end;

if ckb_random.Checked
   then ckb_boucle.Enabled:=false
   else ckb_boucle.Enabled:=true;
end;

procedure TmainForm.btn_prevClick(Sender: TObject);
begin
if step>0
   then step:= step-1
   else step:= 0;
dessine_grille;
update_interface;
end;

procedure TmainForm.TimerLectureTimer(Sender: TObject);
begin
if ckb_random.checked
then
    begin
    step:= trunc(random(length(sequence)));
    end
else
    if step < (length(sequence)-1)
       then step:= step+1
       else
           if ckb_boucle.Checked
           then step:=0
           else timerlecture.Enabled:=false;
update_Interface;
dessine_grille;

end;

procedure TmainForm.btn_playClick(Sender: TObject);
begin
step:= 0;
TimerLecture.Interval:= ctl_speed.Value * delai_base;
timerLecture.Enabled:= true;
update_interface;
end;

procedure TmainForm.btn_stopClick(Sender: TObject);
begin
timerLecture.Enabled:= false;
update_interface;
end;

procedure TmainForm.btn_openClick(Sender: TObject);
begin
if OpenDialog1.Execute
   then begin
        AssignFile(sequence_File, OpenDialog1.Filename);
        Reset(sequence_File);
        load_sequence_file;
        closefile(sequence_file);
        step:= 0;
        update_interface;
        mainForm.Caption:= extractfilename(opendialog1.filename);
        end;
end;

procedure TmainForm.btn_saveClick(Sender: TObject);
var
   hex_filename: string;
begin
if SaveDialog1.Execute
   then begin
        AssignFile(sequence_File, SaveDialog1.Filename);
        Rewrite(sequence_File);
        save_sequence_file;
        closefile(sequence_file);
        mainForm.Caption:= extractfilename(savedialog1.filename);
        end;
end;

procedure TmainForm.load_sequence_file;
begin
step:= 0;
Repeat
      setlength(sequence,step+1);
      readln(sequence_file,sequence[step,0],sequence[step,1],
      sequence[step,2],sequence[step,3],sequence[step,4]);
      step:= step+1;
until eoln(sequence_file);
end;

procedure TmainForm.save_sequence_file;
var
   i:integer;
begin
for i:= 0 to length(sequence)-1 do
    begin
    writeln(sequence_file,sequence[i,0],' ',sequence[i,1],' ',
      sequence[i,2],' ',sequence[i,3],' ',sequence[i,4]);
    end;
end;

procedure TmainForm.btn_firstClick(Sender: TObject);
begin
step:=0;
update_interface;
end;

procedure TmainForm.btn_lastClick(Sender: TObject);
begin
step:= length(sequence)-1;
update_interface;
end;

procedure TmainForm.btn_deleteClick(Sender: TObject);
var
   i:integer;
begin
for i:= step to length(sequence)-2 do
    begin
    sequence[i]:=sequence[i+1];
    end;
setlength(sequence,length(sequence)-1);
if step>(length(sequence)-1) then step:= length(sequence)-1;
update_interface;
end;

procedure TmainForm.btn_insertClick(Sender: TObject);
var
   i: integer;
begin
setlength(sequence, length(sequence)+1);
for i:= length(sequence)-1 downto step+1 do
    begin
    sequence[i]:= sequence[i-1];
    end;
for i:= 0 to 4 do
    sequence[step,i]:= 0;
update_interface;
end;

procedure TmainForm.ckb_randomClick(Sender: TObject);
begin
update_interface
end;

function TMainForm.convertir(m: TFrame): TMemory;
var
   R: TMemory;
begin
R[3]:= 0 + (m[4] shr 4);
R[2]:= (m[3] shr 1) + (m[4] shl 4);
R[1]:= (m[1] shr 3) + (m[2] shl 2) + (m[3] shl 7);
R[0]:= m[0] + (m[1] shl 5);
Result:=R;
end;


procedure TmainForm.btn_newClick(Sender: TObject);
var
   i: integer;
begin
step:= 0;
setlength(sequence,1);
for i:= 0 to 4 do
    sequence[0,i]:= 0;
update_interface;
mainForm.Caption:= 'Squence sans nom';
end;

end.
