'Servo Math
'By Steven R. Cypherd
'V1 2/5/13
'Servo Math
'A standard servo is 5.556us per degree(UPD)
'78 * 5.556 = 433.368 + 1000 = 1434us
'This is for old servos, New one are 8 UPD
'Pulsout unit is 5 for a Picaxe 28x2
'14343 / 5 = 287
'Pulsout port, 287 is 78 degrees on a servo
'Picaxe processors do not support floating point math
'The Picaxe manual has a fix
'78 * 5.556 is 78 / 10 * 56
'Not used here anymore
'Tower Pro Micro SG90 UPD-8, LR-450, HA-220
'*hitec HS-300 UPD-8, LR-800, HA-200
'Micro ? UPD-8, LR-900, HA-180
'UPD - Microseconds Per Degree
'LR  - Low Range
'HA  - High Angle
'Using a Picaxe 28x2
'To run my program
'2 16 bit word size variable
'and Constants
'Run program
'Open a serial terminal
'Press button to run test
'Set Servo at 0
'Adjust UPD so 90 is square
'Set High Angle
'Change setting re-load program

'You need to change your ports
'for other Picaxe processors
symbol svr1 = C.0 'My robot uses all
symbol lit1 = C.1 'of the outputs
symbol btn1 = pinC.2'Pin 2 input

'*********Make setting changes Here
symbol Punit	= 5	;Your Pulsout Unit
symbol srvoUPD	= 8	'Your servo's UPD
symbol RngLow  = 800;Low Range 400-1000
symbol HiAng   = 200	;High Angle 180-250
symbol ReFrsh	= 50	;Refresh rate
symbol setAng	= 20	;Set Angle rate
symbol hitSet	= 15	;Hits to set Servo
symbol litSet	= 100	;Ligh rate
symbol testSet	= 200	;Test rate

symbol sFlags 	= B0   ;Over lapping memory is OK here
symbol svrOn	= BIT0 ;Bit flags are efficient
symbol litOn	= BIT1
symbol bntDwn	= BIT2
symbol cmdDsp	= BIT3
symbol svrTest	= BIT4
symbol svrOff	= BIT5
symbol tmp1		= B1
symbol AngTmp	= W1 ;b2 - b3
symbol cntTest = W2 ;b4 - b5
symbol curAng	= B6
symbol lastAng	= B7
symbol cntLit	= B8
symbol cntHit	= B9
symbol hitRt	= B10
symbol cntSvr	= B11
symbol TestSvr = B12

'My Picaxe 28x2 any port can be any type
'Change or delete as needed
output svr1
output lit1

main:
	sFlags = 0
	litOn = 1
	svrOn = 0
	bntDwn = 0
	svrTest = 0
	svrOff = 0
	cmdDsp = 1
	cntLit = litSet
	cntSvr = ReFrsh
	lastAng = 2 ;Other wise 0 can't be set
	cntTest = testSet
	high lit1
	pause 500 ;Let terminal Open
	
doIt:
	pause 1
	if svrOn = 0 then doLit
	If cntHit > 0 then
		hitRt = hitRt - 1
		if hitRt = 0 then
			hitRt = setAng
			cntHit = cntHit - 1
			gosub angInt
			endif
	else
		cntSvr = cntSvr - 1
		if cntSvr = 0 then
			cntSvr = ReFrsh
			if svrOff = 1 then
				svrOff = 0
				svrOn = 0
				goto doLit
				endif
			gosub angInt
			endif
		endif

doLit:
	cntLit = cntLit - 1
	if cntLit = 0 then
		cntLit = litSet
		if litOn = 1 then
			litOn = 0
			low lit1
		else
			litOn = 1
			high lit1
			endif
		endif
		
	if cntHit > 0 then doBtn
	if svrTest = 1 then
		cntTest = cntTest - 1
		if cntTest = 0 then
			cntTest = testSet
			TestSvr = TestSvr + 1
			if TestSvr = 1 then
				curAng = 0
				sertxd("Angle 0", 13, 10)
			elseif TestSvr = 2 then
				curAng = 90
				sertxd("Angle 90", 13, 10)
			else
				curAng = HiAng
				TestSvr = 0
				sertxd("Angle ", #HiAng, 13, 10)
				endif
			gosub angInt
			endif
		endif

doBtn:	
	if bntDwn = 1 then jp1
	if btn1 = 1 then
		bntDwn = 1
		if svrOn = 1 then
			sertxd("Servo Off", 13, 10)
			svrTest = 0
			cmdDsp = 1
			svrOff = 1
			curAng = 90
			gosub angInt
		else
			sertxd("Old standard", 13, 10) 'Add info here	
			sertxd("Low Range ", #RngLow, 13, 10)
			sertxd("High Angle ", #HiAng, 13, 10)
			sertxd("Servo's UPD ", #srvoUPD, 13, 10)
			sertxd("Testing Servo", 13, 10)
			svrTest = 1
			TestSvr = 0
			cntTest = 1
			lastAng = 2
			endif
		endif
		
jp1:	
	if btn1 = 1 then jp2
	bntDwn = 0
jp2:
	if cmdDsp = 1 then
		sertxd("Push Button", 13, 10)
		cmdDsp = 0
		endif	
	goto doIt
end

'*******Subroutines*******************
angInt:
	if svrOn = 0 then
		svrOn = 1
		endif
		
	if curAng <> lastAng then
		lastAng = curAng
		cntHit = hitSet
		AngTmp = curAng
		if AngTmp = 0 then
			AngTmp = RngLow / Punit
		else
			AngTmp = AngTmp * srvoUPD
			AngTmp = AngTmp + RngLow / Punit
			endif
		endif
	pulsout svr1, AngTmp
	return
	