#include "Wire.h"
#include <OneWire.h>
#define DS1307_I2C_ADDRESS 0x68  // the I2C address of Tiny RTC
//define the start time, for example, I want to monitoring start at 22:00:00
#define STA_HOUR 22
#define STA_MINUTE 00
#define STA_SECOND 0
//define the end time, stop monitoring at 6:30:00
#define END_HOUR 6
#define END_MINUTE 30
#define END_SECOND 0

//define the current time, you can configure the current time in here
#define CURRENT_SECOND 0
#define CURRENT_MINUTE 0
#define CURRENT_HOUR 12
#define CURRENT_DAYOFWEEK 3
#define CURRENT_DAYOFMONTH 16
#define CURRENT_MONTH 3
#define CURRENT_YEAR 2013

//define the trigger temperature, only the temperature higher than 22, the relay will trigger in the specify time
#define TRIGGER_TEMPERATURE 22

OneWire  ds(14);  // on pin 14 for temperature
boolean flag;   //To recorde the state of the temperature sensor


byte second, minute, hour, dayOfWeek, dayOfMonth, month, year;
long staTotalSecond, endTotalSecond, currentTotalSecond;
// Convert normal decimal numbers to binary coded decimal
byte decToBcd(byte val)
{
 return ( (val/10*16) + (val%10) );
}
// Convert binary coded decimal to normal decimal numbers
byte bcdToDec(byte val)
{
 return ( (val/16*10) + (val%16) );
}

void setup() { 
 Wire.begin();
 Serial.begin(19200);
 flag = true;
 staTotalSecond = long(STA_HOUR) * 3600 + long(STA_MINUTE) * 60 + long(STA_SECOND);//to caculate the total seconds
 //Serial.println(staTotalSecond);
 
 endTotalSecond = long(END_HOUR) * 3600 + long(END_MINUTE) * 60 + long(END_SECOND);//to caculate the total seconds
 //Serial.println(endTotalSecond);
 
//define the relay pins, the relay shield have 4 relays
 pinMode(4,OUTPUT);
 pinMode(5,OUTPUT);
 pinMode(6,OUTPUT);
 pinMode(7,OUTPUT);
 
 digitalWrite(4,LOW);
 digitalWrite(5,LOW);
 digitalWrite(6,LOW);
 digitalWrite(7,LOW);
 
 setDateDs1307(); //Set current time to the RTC module,
 //this code is only need run one time, after setting the current time successfully, pleas comment this line.
 
}
void loop() 
{
 float temperature;
 getDateDs1307();//get the time data from tiny RTC
 currentTotalSecond = long(hour) * 3600 + long(minute) * 60 + long(second);
// Serial.println(currentTotalSecond);
 
 if(currentTotalSecond > endTotalSecond && currentTotalSecond < staTotalSecond)// to judge whether the current time in the term of setting
 {
   digitalWrite(5,LOW);//relay off
 }
 else
 {
    temperature = getTemperature('c');//to get the teperature
    if (flag)
    {
      Serial.println(temperature);
      if(temperature > TRIGGER_TEMPERATURE)//if temperature higher than setting temperature, relay on
      {
        digitalWrite(5,HIGH);//relay on
      }
        else
      {
        digitalWrite(5,LOW);//relay off
      }
    }
 } 
 delay(60000);//detect the time and the temperature each 60 seconds
 }

// Function to set the currnt time, change the second&minute&hour to the right time
void setDateDs1307()                
{
  second =00; 
  minute = 51;
  hour  = 10;
  dayOfWeek = 5;
  dayOfMonth =28;
  month =2;
  year= 13;
  Wire.beginTransmission(DS1307_I2C_ADDRESS);
  Wire.write(decToBcd(0));
  Wire.write(decToBcd(second));    // 0 to bit 7 starts the clock
  Wire.write(decToBcd(minute));
  Wire.write(decToBcd(hour));      // If you want 12 hour am/pm you need to set
                                  // bit 6 (also need to change readDateDs1307)
  Wire.write(decToBcd(dayOfWeek));
  Wire.write(decToBcd(dayOfMonth));
  Wire.write(decToBcd(month));
  Wire.write(decToBcd(year));
  Wire.endTransmission();
}

// Function to gets the date and time from the ds1307 and prints result
void getDateDs1307()
{
 // Reset the register pointer
 Wire.beginTransmission(DS1307_I2C_ADDRESS);
 Wire.write(decToBcd(0));
 Wire.endTransmission();
 Wire.requestFrom(DS1307_I2C_ADDRESS, 7);
 second     = bcdToDec(Wire.read() & 0x7f);
 minute     = bcdToDec(Wire.read());
 hour       = bcdToDec(Wire.read() & 0x3f);  // Need to change this if 12 hour am/pm
 dayOfWeek  = bcdToDec(Wire.read());
 dayOfMonth = bcdToDec(Wire.read());
 month      = bcdToDec(Wire.read());
 year       = bcdToDec(Wire.read());  
 Serial.print(hour, DEC);
 Serial.print(":");
 Serial.print(minute, DEC);
 Serial.print(":");
 Serial.print(second, DEC);
 Serial.print("  ");
 Serial.print(month, DEC);
 Serial.print("/");
 Serial.print(dayOfMonth, DEC);
 Serial.print("/");
 Serial.print(year,DEC);
 Serial.print("  ");
 Serial.println();
 //Serial.print("Day of week:");
}

//get the temperature, the paremeter is a char, if it equal to 'f', return fahrenheit,else return celsius
float getTemperature(char unit)
{
   byte i;
  byte present = 0;
  byte type_s = 0;
  byte data[12];
  byte addr[8];
  float celsius, fahrenheit;
  
  if ( !ds.search(addr)) {
 //   Serial.println("No more addresses.");
  //  Serial.println();
    ds.reset_search();
    delay(250);
    flag = false;
    return 0;
  }
  else
    flag = true;

  if (OneWire::crc8(addr, 7) != addr[7]) {
   //   Serial.println("CRC is not valid!");
      return 2;
  }
//  Serial.println();
 
  // the first ROM byte indicates which chip
  switch (addr[0]) {
    case 0x10:
      type_s = 1;
      break;
    case 0x28:
      type_s = 0;
      break;
    case 0x22:
      type_s = 0;
      break;
    default:
      return 3;
  }  

  ds.reset();
  ds.select(addr);
  ds.write(0x44,1);         // start conversion, with parasite power on at the end
  
  delay(1000);     // maybe 750ms is enough, maybe not
  // we might do a ds.depower() here, but the reset will take care of it.
  
  present = ds.reset();
  ds.select(addr);    
  ds.write(0xBE);         // Read Scratchpad
  for ( i = 0; i < 9; i++) {           // we need 9 bytes
    data[i] = ds.read();
  }
  // convert the data to actual temperature

  unsigned int raw = (data[1] << 8) | data[0];
  if (type_s) {
    raw = raw << 3; // 9 bit resolution default
    if (data[7] == 0x10) {
      // count remain gives full 12 bit resolution
      raw = (raw & 0xFFF0) + 12 - data[6];
    }
  } else {
    byte cfg = (data[4] & 0x60);
    if (cfg == 0x00) raw = raw << 3;  // 9 bit resolution, 93.75 ms
    else if (cfg == 0x20) raw = raw << 2; // 10 bit res, 187.5 ms
    else if (cfg == 0x40) raw = raw << 1; // 11 bit res, 375 ms
    // default is 12 bit resolution, 750 ms conversion time
  }
  celsius = (float)raw / 16.0;
  fahrenheit = celsius * 1.8 + 32.0;
  if ('f'== unit)
    return fahrenheit;
  else 
    return celsius;
}



