#include <stdint.h>
#include <math.h>
#include "const.h"
#include "Heat.h"
#include "LED.h"
#include "Touch_Sensor.h"
#include "UI.h"

/*
int8_t dotTarget_i = 0;
float dotTarget = 0;	// on release [0..1]
float dot = 0.0f;	// True dot position [0..1]
float dotShow = 0.0f;	// Smooth dot position, for show [0..1]

float hotness = 0.0f;
float pressAccum = 0.0f;

int lastPos = 0;
bool lastPress = false;

// Thermals
const float HOTNESS_SPEED = 0.0005f;

// Visuals
const float DOT_SPEED = 0.0025f;
const float DOT_SHOW_LERP = 0.08f;
const float THERMO_BRIGHT = 0.25f;
const float DOT_TARGET_LERP = 0.1f;	// on release
const float PRESS_ACCUM_SPEED = 0.005f;
const float PULSE_RATE = 0.0055;
*/

void setup()
{
#	if (DEV_PRINT_TOUCH) || (DEV_PRINT_TOUCH_MIN_MAX) || (DEV_PRINT_GESTURE_RECOG) || (DEV_PRINT_FPS) || (DEV_PRINT_VOLTAGE) || (DEV_PRINT_IDLE_MILLIS)
		Serial.begin(SERIAL_BAUD_RATE);
#	endif

	heat_init();
	led_init();
	touch_sensor_init();
	ui_init();
}

void loop()
{

#	if DEV_TAP_TEST

		uint32_t _now = millis();
		dev_tap_test(_now);
		led_show();

#	else

		bool did_update_leds = ui_tick();

		if (did_update_leds) {
			led_show();
		}

#	endif

}

////////////////////////////////////////////
#if DEV_TAP_TEST
////////////////////////////////////////////

uint8_t tap_light[LED_COUNT];

void dev_tap_test(uint32_t now)
{
	TouchResult * result = touch_tick(now);

	// Tap test
	if (result->status & k_touch_taps) {
		tap_light[min(LED_COUNT - 1, (tap_count - 1) * 2)] = 0xff;
		tap_light[min(LED_COUNT - 1, (tap_count - 1) * 2 + 1)] = 0xff;
	}

	// Fade tap_light's
	for (int8_t i = 0; i < LED_COUNT; i++) {
		if (tap_light[i]) {
			tap_light[i]--;
		}

		uint16_t bright = tap_light[i];
		bright *= bright;
		bright >>= 8;

		led_set(i, bright, bright, 0);
	}
}
#endif
