// Digital potentiometer test

// Bit-bang SPI
const int POT_SCLK = 6;	// PCINT6 = pin 7
const int DIN = 9;	// PCINT9 = pin 3
const int CS = 10;	// PCINT10 = pin 5	. Enable MOSI data receive.

const int POT_READ = 4;	// PCINT4 = pin 9
//const int POT_VCC = 6;	// PCINT6 = pin 7

const int BLINK_TEST = 0;	// PCINT0 = pin 13

// .225V == analogRead() of 46? Maybe?
const int READ_TARGET = 46;

int pot = 0;
int elapsed = 0;
int updates = 0;

void set_digital_pot(byte value)
{
	// Start SPI
	digitalWrite(POT_SCLK, HIGH);
	delayMicroseconds(20);
	digitalWrite(CS, LOW);
	digitalWrite(POT_SCLK, LOW);
	delayMicroseconds(20);

	// Bit-bang SPI. Datasheet says: Rising edge registers the value.
	for (int b = 0; b <= 7; b++) {
		// Bit mask. MSB first.
		byte mask = (0x1) << (7 - b);

		digitalWrite(DIN, (value & mask) ? HIGH : LOW);
		delayMicroseconds(10);
		digitalWrite(POT_SCLK, HIGH);
		delayMicroseconds(20);
		digitalWrite(POT_SCLK, LOW);
		delayMicroseconds(10);
	}

	// Release SPI
	digitalWrite(CS, HIGH);
}

// the setup routine runs once when you press reset:
void setup() {
	// initialize the digital pin as an output.
	pinMode(POT_SCLK, OUTPUT);
	pinMode(DIN, OUTPUT);
	pinMode(CS, OUTPUT);
	pinMode(POT_READ, INPUT);
	/*
	pinMode(POT_VCC, OUTPUT);
	*/

	pinMode(BLINK_TEST, OUTPUT);

	/*
	// Calibrate digital potentiometer
	digitalWrite(POT_VCC, HIGH);
	set_digital_pot(0x0);
	delay(50);

	// More accurate?: Gather a bunch of samples, average them out
	const byte SAMPLES = 8;
	int result = 0;
	for (byte i = 0; i < SAMPLES; i++) {
		result += analogRead(POT_READ);
	}

	// Maximum achievable ohms
	float scale = 1.0f - (result / (float)(SAMPLES)) / 1023.0f;
	maxOhms = 10000.0f * scale;
	*/
}

void loop() {
	/*
	// Saw -> Triangle wave:  /\/\/\ etc
	byte valueByte = (phase & 0xff);
	if (phase > 0xff) {
		valueByte = 0xff - valueByte;
	}

	set_digital_pot(valueByte);

	// Increment the waveform, and loop it.
	phase++;
	if (phase >= 512) {
		phase = 0;
	}

	//set_digital_pot_ohms(5000.0f);

	delay(100);
	*/

	// Write the pot value to the digital resistor
	set_digital_pot(0xff - (byte)pot);

	// Take a reading
	int read = analogRead(POT_READ);

	if (read < READ_TARGET) {
		pot = max(pot - 1, 0);

	} else if (read > READ_TARGET) {
		pot = min(pot + 1, 0xff);
	}

	digitalWrite(BLINK_TEST, (updates % 60) ? LOW : HIGH);

	const int WAIT = 40;
	delay(WAIT);
	elapsed += WAIT;
	updates++;

	// Every 15 seconds: Reset just to prove something is happening
	if (elapsed >= (20 * 1000)) {
		elapsed = 0;
		pot = 0;
	}

}
