#! /bin/sh
# Split Fuji W3 3D-Video to seperate files and combine them to a side-by-side-movie

# Sicherheitsabfrage
BOO=true
HSIZE=1280
VSIZE=720

# Check for a filename
if [ "$#" != 1 ]
  then echo "please give movie-file as parameter!"
exit 
# elseif [ "$1" = "./" ]
else
 echo "This script splits a Fuji W3 3D-movie in two separate films and combines them side by side for google cardboard"
 
# Additional check before starting
 while $BOO;
 do  
 read -p "Split file:  $1  (Yes)" answer
 case "$answer" in
        # Answer starts with Y or y or is empty (enter pressed) "" --> Start
        [Yy]*|"") echo "Ok, let's do it!"
        BOO=false     
            ;;
        # Answer starts with N oder n --> Stop
        [Nn]*) echo "Execution canceled"
                   exit 1
            ;;
        # Antwort ist etwas anderes
        *) echo "Answer only Yes or No!"
            ;;
 esac
 done

fi

# Split in two separate movies
ffmpeg -i $1 -map 0:0 -map 0:1 -vcodec copy -acodec copy templeft.avi
ffmpeg -i $1 -map 0:2 -vcodec copy -an tempright.avi

# join to a side-by-side-movie
ffmpeg -i templeft.avi -r 24 -b:v 24000k -vf "movie=tempright.avi [in1]; [in]pad=$HSIZE*2:$VSIZE[in0]; [in0][in1] overlay=$HSIZE:0 [out]" $1_24lr.avi

# remove temporal movies
rm templeft.avi
rm tempright.avi
