#! /bin/sh
# Split MPO files and join to side-by-side 

LIST=`ls *.MPO`

for f in $LIST
do
   # extract the two images from the MPO
   echo Converting: $f
   exiftool -trailer:all= $f -o ${f}_l.jpg
   exiftool $f -mpimage2 -b > ${f}_r.jpg

   # Make left-right Side-by-Side-Pictures
   convert +append ${f}_l.jpg ${f}_r.jpg ${f}_lr.jpg
   
done

# optional step: Make an mpo-folder and move all MPOs 
mkdir mpo
mv *.MPO ./mpo

# remove temporary pictures
rm *_l.jpg
rm *_r.jpg

