/*		ATtiny85
	reset --^-- Vcc
		3 |   | 2
		4 |   | 1
	  gnd ----- 0
*/	

#include <avr/io.h>
#include <util/delay.h>

/*	cathode (c)(marked with a dot on the board) is short (-) lead, anode (a) is longer (+) lead
	possible values are {1, 2, 3, or 4}
	there should be 3 of each # for both c[] and a[]
	also notice the each pair is the reversed pair of the opposite array								*/
int a[]={3,1,3,2,2,1,2,4,4,1,4,3};		
int c[]={1,3,2,3,1,2,4,2,1,4,3,4};	

int main(void)
{		
	DDRB  = 0b11111110;		// 0 = input, 1 = output
	PORTB = 0b00000000;		// 0 = low,   1 = high,    (1 = high impedance on input lines)
	
	//int ncounter=0;		// index for pattern selection
	//int nmax=3;	// number of different patterns
	
	while(1)
	{	
		//trouble getting the button to work right. constantly triggers.
		/*
		if ((PINB & 0b00000001) == 1)	// read pinb0, check if button pressed
		{
			ncounter++;
			if(ncounter>3) ncounter=0;		
		}		
		
		if(ncounter==0)	// pattern 0 - All on
		{ AllOn(0); }
		
		else if(ncounter==1)	// pattern 1 - Spin cycle
		{ spin(100); }
		*/
		
		/*
		for(int at=0;at<400;at++)
		{
			AllOn(2);
		}
		spin(100);
		spin(100);
		spin(100);
		spin(100);
		spin(100);
		spin(100);
		spin(100);
		spin(100);
		spin(100);
		spin(100);
		*/
		
		stagger(60);
		stagger(60);
		stagger(60);
		stagger(60);
		stagger(60);
		stagger(60);
		spin(100);
		spin(100);
		spin(100);
		spin(100);
		spin(100);
		spin(100);
		spin(100);
		for(int at=0;at<400;at++)
		{
			AllOn(2);
		}
	}
	return 0;
}

void delay(int ms)		//used so that clock frequency doesn't matter and so that you can use larger numbers without it cutting off...
{						// must write our own delay function since _delay_ms(int) only accepts constants (we can't pass a variable to it)
	for(int t=0;t<ms;t++)
	{
		_delay_ms(1);
	}
}
void udelay(int us)		
{			
	for(int t=0;t<us;t++)
	{
		_delay_us(1);
	}
}

void op(int n)					// op() turns on the selected LED by LED number (does all the magic for the charlieplexing)
{
	allOff();
	int cn = c[n-1];
	int an = a[n-1];
	//---------cathode
		DDRB = _BV(cn);			// set as output
		PORTB = _BV(cn);		// write high
	//---------anode
		DDRB |= _BV(an);		// set as output, left as low
}
void AllOn(int dt)	
{  
	for(int i=1;i<13;i++) 
	{ op(i); delay(dt); } 
}
void allOff()	
{  
	PORTB &= 0;				// sets all to low
	DDRB = 0b00000000;		// set all to inputs
}

void spin(int delaytime)
{
	for(int k=1;k<13;k++)
	{
		op(k);
		delay(delaytime);
	}
}
/*
void blink(int delaytime, int time_on, int time_off)
{
	for(int i=1;i<13;i++)
	{
		op(i);
		delay(delaytime);
	}
	delay(time_on);
	allOff();
	delay(time_off);
}
*/

// doesn't work as intended
/*
void wcos(int pause)
{
	faze(8, pause, 2);
	faze(9, pause, 2);
	faze(10, pause, 2);
	faze(11, pause, 2);
	faze(12, pause, 2);
	faze(1, pause, 2);
	faze(2, pause, 2);
	faze(3, pause, 2);
	faze(4, pause, 2);
	faze(5, pause, 2);
	faze(6, pause, 2);
	faze(7, pause, 2);
}	

void faze(int LED, int pause, int proximity)
{
	for(int r = proximity; r>0; r--)
	{
		reverse(LED,r);
		cdelay(pause, r);
	}
	op(LED);
	cdelay(pause, 0);
	for(int f = proximity; f>0; f--)
	{
		forward(LED,f);
		cdelay(pause, f);
	}
}

void forward(int LED, int proximity)
{
	if((LED + proximity) > 12) op(LED + proximity - 12);
	else op(LED + proximity);
}

void reverse(int LED, int proximity)		// I realize that these are exactly the same function and can easily be combined, I'm just care enough to fix the code...
{
	if((LED - proximity) < 0) op(LED - proximity + 12);
	else op(LED - proximity);
}

void cdelay(int pause, int proximity)
{
	int wait = (pause * 10) / (proximity * 30 + 1);
	udelay(wait);
}
*/

stagger(int pause)
{
	for(int m=0;m<pause;m++)
	{
		op(1);
		delay(2);
		op(3);
		delay(2);
		op(5);
		delay(2);
		op(7);
		delay(2);
		op(9);
		delay(2);
		op(11);
		delay(2);
	}	
	
	for(int m=0;m<pause;m++)
	{
		op(2);
		delay(2);
		op(4);
		delay(2);
		op(6);
		delay(2);
		op(8);
		delay(2);
		op(10);
		delay(2);
		op(12);
		delay(2);
	}	
}